package w83b.w83bOperacionesPaso.w83bPreavisos;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.lang.StringUtils;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.hssf.util.Region;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

import w83b.w83bBeans.W83bPreavisosBean;
import w83b.w83bBeans.W83bUsuarioXLNetsBean;
import w83b.w83bUtilidades.W83bUtilidadesComunes;
import w83b.w83bUtilidades.W83bUtilidadesExcel;
import w83b.w83bUtilidadesComunes.W83bClsConstantes;
import w83b.w83bUtilidadesComunes.W83bUtilidades;
import es.ejie.frmk.infraestructura.internacionalizacion.Q70GestorMensajesi18n;
import es.ejie.frmk.listeners.base.Q70ListenerUtils;
import es.ejie.frmk.presentacion.operacion.paso.Q70ActionPasoOP;
import es.ejie.frmk.presentacion.sesiondatos.Q70ContextoEJIE;

public class W83bTablaPreavisosExcelAction extends Q70ActionPasoOP{


	
	protected void processOP(Q70ContextoEJIE contexto, ActionErrors errores, ActionMapping mapping,
			ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
		
		
	}

	protected ActionForward processForward(Q70ContextoEJIE contexto, ActionErrors errors, ActionMapping mapping, 
			ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {

		String strRutaExcel = Q70ListenerUtils.getApplicationProperty("RUTA_PLANTILLAS_EXCEL")+"plantillaExcelw83bListadoPreavisos.xls";
		InputStream inputStream = W83bTablaPreavisosExcelAction.class.getResourceAsStream(strRutaExcel);
		HSSFWorkbook wb = new HSSFWorkbook(inputStream); // Creacin del libro
		wb.setSheetName(0,"Hoja1"); // Creacin de la hoja
        HSSFSheet sheet = wb.getSheetAt(0); // Creacin de la hoja
        
        List listaPreavisos = (ArrayList)contexto.get("w83bListaPreavisos");
        W83bPreavisosBean preavisosBean = (W83bPreavisosBean)contexto.get("w83bPreavisosTempBean");
        
        W83bUtilidadesExcel excel = new W83bUtilidadesExcel(wb);
        
        W83bUsuarioXLNetsBean usuario = (W83bUsuarioXLNetsBean)contexto.get(W83bClsConstantes.CONSTANTE_CONTEXTO_USUARIO);
        
        String idioma = (String)contexto.get(W83bClsConstantes.CONSTANTE_CONTEXTO_IDIOMA);
        
        W83bUtilidadesExcel.crearCabeceraPieEstandar(sheet, idioma,(W83bUsuarioXLNetsBean)contexto.get(W83bClsConstantes.CONSTANTE_CONTEXTO_USUARIO));      
        HashMap mapaDelegaciones=  W83bUtilidadesComunes.obtenerTitulosDelegacionDepartamento(usuario,idioma);   
        
        HSSFRow row = sheet.createRow((short)1); // Creacin de la fila 1
        HSSFCell cell = row.createCell((short)3);

        
        row = sheet.getRow((short)4); 
        cell = row.getCell((short)4);
        
        StringBuffer tituloImagenEs = (StringBuffer)mapaDelegaciones.get("tituloDepEs");    
        StringBuffer tituloImagenEu =  (StringBuffer)mapaDelegaciones.get("tituloDepEu");
        
        cell.setCellValue(tituloImagenEu.toString());
        
        cell = row.getCell((short)7); 
        cell.setCellValue(tituloImagenEs.toString());
        
        
        tituloImagenEs = (StringBuffer)mapaDelegaciones.get("tituloDelelegacionEs");    
        tituloImagenEu = (StringBuffer)mapaDelegaciones.get("tituloDelelegacionEu");    
        
        row = sheet.getRow((short)6); 
        cell = row.getCell((short)4);
        cell.setCellValue(tituloImagenEu.toString());
        
        cell = row.getCell((short)7); 
        cell.setCellValue(tituloImagenEs.toString());
        
        row = sheet.getRow((short)9); 
        cell = row.getCell((short)0);
        StringBuffer titulo = new StringBuffer();
        titulo.append(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.informes.tituloPreavisos_eu",idioma));
        titulo.append(" ");
        titulo.append("/");
        titulo.append(" ");
        titulo.append(Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.informes.tituloPreavisos_es",idioma));
        cell.setCellValue(titulo.toString());
        
        //MAPEO FORMULARIO
        //NUMERO Preaviso
        row = sheet.getRow((short)12); 
        cell = row.getCell((short)1); 
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.preavisos.tabla.num_preaviso_dh"));
        cell = row.getCell((short)3);        
        String nPreavisosDesde = "";
        StringBuffer nPreavisosHasta = new StringBuffer();
        
        
        
        boolean desde = false;
        
        if(StringUtils.isNotEmpty(preavisosBean.getCodTerritorioDesde())||
        		StringUtils.isNotEmpty(preavisosBean.getAnyoDesde())||
        		StringUtils.isNotEmpty(preavisosBean.getNumpreaviso_desde())){
        	desde = true;
        }        
        
        if(StringUtils.isNotEmpty(preavisosBean.getCodTerritorioDesde())){
        	nPreavisosDesde = preavisosBean.getCodTerritorioDesde();
        }else if(StringUtils.isNotEmpty(preavisosBean.getNumpreaviso_desde())){
        	nPreavisosDesde = "-";
        }
        if(!"".equals(nPreavisosDesde)){
        	if(StringUtils.isNotEmpty(preavisosBean.getAnyoDesde())){
        		nPreavisosDesde = nPreavisosDesde + "/" +preavisosBean.getAnyoDesde();//NOPMD       		
        	}else{
        		nPreavisosDesde = nPreavisosDesde + "/-"; //NOPMD       		
        	}
        }else{
        	nPreavisosDesde = preavisosBean.getAnyoDesde();      	
        }
        
        if(StringUtils.isNotEmpty(preavisosBean.getNumpreaviso_desde())){
        	nPreavisosDesde = nPreavisosDesde + "/" +preavisosBean.getNumpreaviso_desde(); //NOPMD       	
        }else if(StringUtils.isNotEmpty(preavisosBean.getCodTerritorioDesde())){
        	nPreavisosDesde = nPreavisosDesde + "/-"; //NOPMD       	
        }
        
        if(StringUtils.isNotEmpty(preavisosBean.getCodTerritorioHasta())||
        		StringUtils.isNotEmpty(preavisosBean.getAnyoHasta())||
        		StringUtils.isNotEmpty(preavisosBean.getNumpreaviso_hasta())){
        	if(desde){
        		nPreavisosHasta.append(" al ");
        	}
        }
        
  
        if(StringUtils.isNotEmpty(preavisosBean.getCodTerritorioHasta())){
        	nPreavisosHasta.append(preavisosBean.getCodTerritorioHasta());
        }else if(StringUtils.isNotEmpty(preavisosBean.getNumpreaviso_hasta())){
        	nPreavisosHasta.append("-");
        }
        if(StringUtils.isNotEmpty(preavisosBean.getCodTerritorioHasta())){
        	if(StringUtils.isNotEmpty(preavisosBean.getAnyoHasta())){
        		nPreavisosHasta.append("/" +preavisosBean.getAnyoHasta());//NOPMD       		
        	}else{
        		nPreavisosHasta.append("/-"); //NOPMD       		
        	}
        }else{
        	nPreavisosHasta.append(preavisosBean.getAnyoHasta());      	
        }
        if(StringUtils.isNotEmpty(preavisosBean.getNumpreaviso_hasta())){
        	nPreavisosHasta.append("/" +preavisosBean.getNumpreaviso_hasta()); //NOPMD       	
        }else if(StringUtils.isNotEmpty(preavisosBean.getCodTerritorioHasta())){
        	nPreavisosHasta.append("/-"); //NOPMD       	
        }
      
        cell.setCellValue(nPreavisosDesde +nPreavisosHasta );
      //fin NUMERO Preaviso
       

        row = sheet.getRow((short)13); 
        cell = row.getCell((short)1); 
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.preavisos.label.cifNifCentroTrabajo"));
        cell = row.getCell((short)3);        
        
        cell.setCellValue(preavisosBean.getCentroTrabajo().getCifnif()+ " "+ preavisosBean.getCentroTrabajo().getNumCentro());        
        cell = row.getCell((short)4); 
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.actas.razonSocial"));
        cell = row.getCell((short)6);   
        if(StringUtils.isNotEmpty(preavisosBean.getCentroTrabajo().getRazonSocial())){
        	sheet.addMergedRegion(new Region(W83bClsConstantes.TRECE,Short.parseShort("6"),W83bClsConstantes.TRECE,Short.parseShort("7")));//NOPMD
        	cell.setCellValue(preavisosBean.getCentroTrabajo().getRazonSocial().toUpperCase());
        }else{
        	cell.setCellValue("");
        }
        
        row = sheet.getRow((short)14); 
        cell = row.getCell((short)1); 
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.actas.provincia"));
        cell = row.getCell((short)3);        
        if(StringUtils.isNotEmpty(preavisosBean.getCentroTrabajo().getTerritorio())){
        	cell.setCellValue(preavisosBean.getCentroTrabajo().getTerritorio().toUpperCase());
        }
        cell = row.getCell((short)4); 
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.actas.municipio"));
        cell = row.getCell((short)6);        
        
        if(StringUtils.isNotEmpty(preavisosBean.getCentroTrabajo().getMunicipio())){
        	sheet.addMergedRegion(new Region(W83bClsConstantes.CATORCE,Short.parseShort("6"),W83bClsConstantes.CATORCE,Short.parseShort("7")));//NOPMD
        	cell.setCellValue(preavisosBean.getCentroTrabajo().getMunicipio().toUpperCase());
        }else{
        	cell.setCellValue("");
        }
        //fin CENTRO TRABAJO        
      
        //FECHA DE ENTRADA
        row = sheet.getRow((short)15); 
        cell = row.getCell((short)1); 
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.preavisos.tabla.entrada_dh"));
        cell = row.getCell((short)3);        

        String fechaEntrada = "";
        desde = false;
        if(StringUtils.isNotEmpty(preavisosBean.getFecha_entrada_desde())){
        	fechaEntrada = preavisosBean.getFecha_entrada_desde();
        	desde = true;
        }
        if(StringUtils.isNotEmpty(preavisosBean.getFecha_entrada_hasta())){
        	if(desde){
        		fechaEntrada = fechaEntrada + "-";//NOPMD
        	}
        	fechaEntrada = fechaEntrada + preavisosBean.getFecha_entrada_hasta();//NOPMD
        }
        cell.setCellValue(fechaEntrada);
      //fin FECHA DE ENTRADA     
        
        //FECHA DE Eleccin
        cell = row.getCell((short)4); 
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.preavisos.labels.fecheleccion_dh"));        
        cell = row.getCell((short)6); 
        String fechaEleccion = "";
        desde = false;
        if(StringUtils.isNotEmpty(preavisosBean.getFecha_eleccion_desde())){
        	fechaEleccion = preavisosBean.getFecha_eleccion_desde();
        	desde = true;
        }
        if(StringUtils.isNotEmpty(preavisosBean.getFecha_eleccion_hasta())){
        	if(desde){
        		fechaEleccion = fechaEleccion + "-";//NOPMD
        	}
        	fechaEleccion = fechaEleccion + preavisosBean.getFecha_eleccion_hasta();//NOPMD
        }
        if(StringUtils.isNotEmpty(fechaEleccion)){
        	sheet.addMergedRegion(new Region(W83bClsConstantes.QUINCE,Short.parseShort("6"),W83bClsConstantes.QUINCE,Short.parseShort("7")));//NOPMD
        	cell.setCellValue(fechaEleccion);
        }else{
        	cell.setCellValue("");
        }
        
        row = sheet.getRow((short)15); 
        cell = row.getCell((short)8); 
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.preavisos.labels.sinfeleccion"));
        cell = row.getCell((short)10);        
        
        String sinEleccion = "";
        
        if(W83bClsConstantes.CONSTANTE_SI.equals(preavisosBean.getSinfechaeleccion())){
        	sinEleccion = Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.herramientas.si",idioma).toUpperCase();
        }else {
        	sinEleccion = Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.herramientas.no",idioma).toUpperCase();        	
        }        
        cell.setCellValue(sinEleccion);   
        //fin FECHA DE COMISIN
        
        //FECHA DE ELECCIN
        row = sheet.getRow((short)15); 
        cell = row.getCell((short)11); 
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.preavisos.labels.fechinicio_dh"));
        cell = row.getCell((short)12);        

        String fechaInicio = "";
        desde = false;
        if(StringUtils.isNotEmpty(preavisosBean.getFecha_inicio_desde())){
        	fechaInicio = preavisosBean.getFecha_inicio_desde();
        	desde = true;
        }
        if(StringUtils.isNotEmpty(preavisosBean.getFecha_inicio_hasta())){
        	if(desde){
        		fechaInicio = fechaInicio + "-";//NOPMD
        	}
        	fechaInicio = fechaInicio + preavisosBean.getFecha_inicio_hasta();//NOPMD
        }
        if(StringUtils.isNotEmpty(fechaInicio)){
        	sheet.addMergedRegion(new Region(W83bClsConstantes.QUINCE,Short.parseShort("12"),W83bClsConstantes.QUINCE,Short.parseShort("13")));//NOPMD
        	cell.setCellValue(fechaInicio);
        }else{
        	cell.setCellValue("");
        }
      //fin FECHA DE ELECCIN 
        
        //Eleccin parcial
        row = sheet.getRow((short)12); 
        cell = row.getCell((short)4); 
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.preavisos.labels.eleccionparcial"));
        cell = row.getCell((short)6);        
        
        String eleccionParcial = "";
        
        if(W83bClsConstantes.CONSTANTE_SI.equals(preavisosBean.getEleccion_parcial())){
        	eleccionParcial = Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.herramientas.si",idioma);
        }     
        cell.setCellValue(eleccionParcial);   
        //Fin de eleccin parcial
        //Preaviso Global
        row = sheet.getRow((short)12); 
        cell = row.getCell((short)8); 
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.preavisos.labels.prevglobal"));
        cell = row.getCell((short)10);        
        
        String prevGlobal = "";
        
        if(W83bClsConstantes.CONSTANTE_SI.equals(preavisosBean.getPreaviso_global())){
        	prevGlobal = Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.herramientas.si",idioma).toUpperCase();
        }     
        cell.setCellValue(prevGlobal);   
        //Fin de preaviso global

        
        //FECHA TRAMITE
        row = sheet.getRow((short)16); 
        cell = row.getCell((short)1); 
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.preavisos.tabla.tramite_dh"));
        cell = row.getCell((short)3);        

        String fechaTramite = "";
        desde = false;
        if(StringUtils.isNotEmpty(preavisosBean.getFecha_tramite_desde())){
        	fechaTramite = preavisosBean.getFecha_tramite_desde();
        	desde = true;
        }
        if(StringUtils.isNotEmpty(preavisosBean.getFecha_tramite_hasta())){
        	if(desde){
        		fechaTramite = fechaTramite + "-";//NOPMD
        	}
        	fechaTramite = fechaTramite + preavisosBean.getFecha_tramite_hasta();//NOPMD
        }
        cell.setCellValue(fechaTramite);
        
        row = sheet.getRow((short)16); 
        cell = row.getCell((short)8); 
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.preavisos.labels.tramite"));
        cell = row.getCell((short)10);        
        
        if(StringUtils.isNotEmpty(preavisosBean.getTramiteTxt())){
            sheet.addMergedRegion(new Region(W83bClsConstantes.DIECISEIS,Short.parseShort("10"),W83bClsConstantes.DIECISEIS,Short.parseShort("13")));//NOPMD
            cell.setCellValue(preavisosBean.getTramiteTxt().toUpperCase());
        }else{
        	cell.setCellValue("");
        }
        
        row = sheet.getRow((short)16); 
        cell = row.getCell((short)4); 
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.preavisos.labels.ultimo_tramite"));
        cell = row.getCell((short)6);        
        
        String ultTramite = "";
        
        if(W83bClsConstantes.CONSTANTE_SI.equals(preavisosBean.getUtramite())){
        	ultTramite = Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.herramientas.si",idioma).toUpperCase();
        }else {
        	ultTramite = Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.herramientas.no",idioma).toUpperCase();        	
        }      
        cell.setCellValue(ultTramite);    
      //fin TRAMITE   

        
        //Creamos la cabecera de la tabla
        //El ancho de las columnas se han hallado con la formula (20*tamnyo columna en chars)/(1/20)
        row = sheet.getRow((short)19); // Creacin de la fila 1
        cell = row.getCell((short)0); // Creacin de la columna 1 para la fila 1
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.preavisos.campos.numPreaviso"));
        
        cell = row.getCell((short)1); // Creacin de la columna 2 para la fila 1
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.preavisos.campos.fecha_entrada"));
        
        cell = row.getCell((short)2); // Creacin de la columna 3 para la fila 1
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.preavisos.campos.fecha_inicio"));
        
        cell = row.getCell((short)3); // Creacin de la columna 4 para la fila 1
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.actas.razonSocial"));
        
        cell = row.getCell((short)4); // Creacin de la columna 5 para la fila 1
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.actas.cif"));
        
        cell = row.getCell((short)5); // Creacin de la columna 6 para la fila 1
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.actas.nCentro"));
        
        cell = row.getCell((short)6); // Creacin de la columna 8 para la fila 1
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.centroTrabajo.t"));
        
        cell = row.getCell((short)7); // Creacin de la columna 9 para la fila 1
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.centroTrabajo.municipio"));
       
        
        cell = row.getCell((short)8); // Creacin de la columna 11 para la fila 1
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.preavisos.labels.fechelecabrev"));
        
        cell = row.getCell((short)9); // Creacin de la columna 12 para la fila 1
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.preavisos.tabla.elecabrev_parcial"));
        
        cell = row.getCell((short)10); // Creacin de la columna 12 para la fila 1
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.informes.prgl"));
        
        cell = row.getCell((short)11); // Creacin de la columna 13 para la fila 1
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.preavisos.labels.convenio"));
        
        cell = row.getCell((short)12); // Creacin de la columna 14 para la fila 1
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.preavisos.labels.admonempresabrev"));
        
        cell = row.getCell((short)13); // Creacin de la columna 15 para la fila 1
        cell.setCellValue(W83bUtilidadesComunes.rellenarCabecera("w83bcomun","comun.preavisos.labels.centrosafectadosabrev"));
        
        for(int i=0;i<listaPreavisos.size();i++){
        	row = sheet.createRow((short)20+i); // Creacin de la fila 1
        	
        	//Numero PReaviso
        	cell = row.createCell((short)0); 
        	if(StringUtils.isNotEmpty(((W83bPreavisosBean)listaPreavisos.get(i)).getNumPreaviso_completo())){
        		cell.setCellValue(((W83bPreavisosBean)listaPreavisos.get(i)).getNumPreaviso_completo());
        	}
        	cell.setCellStyle(estiloFilaCentro(i,excel));
        	
        	//Fecha entrada
        	cell = row.createCell((short)1); 
        	if(StringUtils.isNotEmpty(((W83bPreavisosBean)listaPreavisos.get(i)).getFecha_entrada())){
        		cell.setCellValue(((W83bPreavisosBean)listaPreavisos.get(i)).getFecha_entrada());
        	}
        	cell.setCellStyle(estiloFilaCentro(i,excel));
        	
        	//Fecha inicio
        	cell = row.createCell((short)2); 
        	if(StringUtils.isNotEmpty(((W83bPreavisosBean)listaPreavisos.get(i)).getFecha_inicio())){
        		cell.setCellValue(((W83bPreavisosBean)listaPreavisos.get(i)).getFecha_inicio());
        	}
        	cell.setCellStyle(estiloFilaCentro(i,excel));
        	
        	//Razon social
        	cell = row.createCell((short)3); 
        	if(StringUtils.isNotEmpty(((W83bPreavisosBean)listaPreavisos.get(i)).getCentroTrabajo().getRazonSocial())){
        		cell.setCellValue(W83bUtilidadesExcel.mayusculasCampoExcel(((W83bPreavisosBean)listaPreavisos.get(i)).getCentroTrabajo().getRazonSocial()));
        	}
        	cell.setCellStyle(estiloFila(i,excel));
        	
        	//Cif
        	cell = row.createCell((short)4); 
        	if(StringUtils.isNotEmpty(((W83bPreavisosBean)listaPreavisos.get(i)).getCentroTrabajo().getCifnif())){
        		cell.setCellValue(((W83bPreavisosBean)listaPreavisos.get(i)).getCentroTrabajo().getCifnif());
        	}
        	cell.setCellStyle(estiloFilaCentro(i,excel));
        	
        	//Num centro
        	cell = row.createCell((short)5); 
        	if(StringUtils.isNotEmpty(((W83bPreavisosBean)listaPreavisos.get(i)).getCentroTrabajo().getNumCentro())){
        		cell.setCellValue(W83bUtilidades.numero(((W83bPreavisosBean)listaPreavisos.get(i)).getCentroTrabajo().getNumCentro()));
        	}
        	cell.setCellStyle(estiloFilaCentro(i,excel));
        
        	//Territorio
        	cell = row.createCell((short)6); 
        	if(StringUtils.isNotEmpty(((W83bPreavisosBean)listaPreavisos.get(i)).getCentroTrabajo().getTerritorio())){
        		cell.setCellValue(W83bUtilidadesExcel.mayusculasCampoExcel(((W83bPreavisosBean)listaPreavisos.get(i)).getCentroTrabajo().getTerritorio()));
        	}
        	cell.setCellStyle(estiloFila(i,excel));
        	
        	//Municipio
        	cell = row.createCell((short)7); 
        	if(StringUtils.isNotEmpty(((W83bPreavisosBean)listaPreavisos.get(i)).getCentroTrabajo().getMunicipio())){
        		cell.setCellValue(W83bUtilidadesExcel.mayusculasCampoExcel(((W83bPreavisosBean)listaPreavisos.get(i)).getCentroTrabajo().getMunicipio()));
        	}
        	cell.setCellStyle(estiloFila(i,excel));
        	
        	//Fecha eleccion
        	cell = row.createCell((short)8); 
        	if(StringUtils.isNotEmpty(((W83bPreavisosBean)listaPreavisos.get(i)).getFecha_eleccion())){
        		cell.setCellValue(((W83bPreavisosBean)listaPreavisos.get(i)).getFecha_eleccion());
        	}
        	cell.setCellStyle(estiloFilaCentro(i,excel));
        	
        	//Eleccion parcial
        	cell = row.createCell((short)9); 
        	
        	String eleccionParcialTabla = "";
        	
            if(W83bClsConstantes.CONSTANTE_SI.equals(((W83bPreavisosBean)listaPreavisos.get(i)).getEleccion_parcial())){
            	eleccionParcialTabla = Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.herramientas.si",idioma).toUpperCase();
            }else {
            	eleccionParcialTabla = Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.herramientas.no",idioma).toUpperCase();        	
            }
            cell.setCellValue(eleccionParcialTabla);
            cell.setCellStyle(estiloFilaCentro(i,excel));
            
            cell = row.createCell((short)10);
            String preavisoGlobalTabla = "";
            if(W83bClsConstantes.CONSTANTE_SI.equals(((W83bPreavisosBean)listaPreavisos.get(i)).getPreaviso_global())){
            	preavisoGlobalTabla = Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.herramientas.si",idioma).toUpperCase();
            }else {
            	preavisoGlobalTabla = Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.herramientas.no",idioma).toUpperCase();        	
            }            	
        	
        	cell.setCellValue(preavisoGlobalTabla);
        	cell.setCellStyle(estiloFilaCentro(i,excel));
        	
        	//Convenio
        	cell = row.createCell((short)11);
        	String convenio = ""; 
        	if(StringUtils.isNotEmpty(((W83bPreavisosBean)listaPreavisos.get(i)).getCodConvenio())){
        		convenio = new StringBuffer(1).append(((W83bPreavisosBean)listaPreavisos.get(i)).getCodConvenio()).append("-").append(((W83bPreavisosBean)listaPreavisos.get(i)).getDescConvenio()).toString();//NOPMD
        	}
        	cell.setCellValue(convenio);
        	cell.setCellStyle(estiloFila(i,excel));
        	
        	//Eleccion parcial
        	cell = row.createCell((short)12); 
        	
        	
        	String empresa = "";
        	if(W83bClsConstantes.CONSTANTE_ADMON.equals(((W83bPreavisosBean)listaPreavisos.get(i)).getAdmon())){
        		empresa = Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.preavisos.labels.admon",idioma).toUpperCase();
            }else {
            	empresa = Q70GestorMensajesi18n.getSingleton().getMessage("w83bcomun","comun.preavisos.labels.empresa",idioma).toUpperCase();        	
            } 
        	
        	cell.setCellValue(empresa);
        	cell.setCellStyle(estiloFilaCentro(i,excel));
        	
        	//Eleccion parcial
        	cell = row.createCell((short)13); 
        	if(StringUtils.isNotEmpty(((W83bPreavisosBean)listaPreavisos.get(i)).getNum_centros_afectados())){
        		cell.setCellValue(W83bUtilidades.numero(((W83bPreavisosBean)listaPreavisos.get(i)).getNum_centros_afectados()));
        	}
        	cell.setCellStyle(estiloFilaCentro(i,excel));
        }
        
		
        byte[] bytesExcel = W83bUtilidadesExcel.fncExcelToBytes(wb);
        
        response.setContentType("application/vnd.ms-excel");
        response.setContentLength(bytesExcel.length);
        response.setHeader("Content-disposition","attachment;filename=listadoPreavisos.xls");
        response.getOutputStream().write(bytesExcel);
        response.getOutputStream().flush();

		
		return null;
	}
	
	private HSSFCellStyle estiloFila(int nFila, W83bUtilidadesExcel excel){
		if(nFila%2==0){
			return excel.styleTextoPar;
		}else{
			return excel.styleTextoImpar;			
		}
		
	}
	
	
	private HSSFCellStyle estiloFilaCentro(int nFila, W83bUtilidadesExcel excel){
		if(nFila%2==0){
			return excel.styleTextoParNumeroCentrado;
		}else{
			return excel.styleTextoImparNumeroCentrado;			
		}
		
	}
	
	


}
